<#--
Application display templates can be used to modify the look of a
specific application.

Please use the left panel to quickly add commonly used variables.
Autocomplete is also available and can be invoked by typing "${".
-->


<#assign serviceContext = staticUtil["com.liferay.portal.kernel.service.ServiceContextThreadLocal"] />

<#assign DLFileEntryLocalService = serviceLocator.findService("com.liferay.document.library.kernel.service.DLFileEntryLocalService")>

<#assign DLUtil =serviceLocator.findService("com.liferay.document.library.kernel.util.DLUtil")>

<#assign DLAppLocalService = serviceLocator.findService("com.liferay.document.library.kernel.service.DLAppLocalService")>

<#assign DLFolderLocalService = serviceLocator.findService("com.liferay.document.library.kernel.service.DLFolderLocalService")>

<#assign themeDisplay = serviceContext.getServiceContext().getThemeDisplay()/>
<#attempt>
<#assign folder=DLFolderLocalService.fetchFolder(themeDisplay.getScopeGroupId(), 0, "PDF Download") >

<#assign pdfIconFileEntry =DLAppLocalService.getFileEntry(themeDisplay.getScopeGroupId(), 0, "pdf-download") />

<#assign fileEntries = DLFileEntryLocalService.getFileEntries(themeDisplay.getScopeGroupId(), folder.getFolderId())/>

<#assign pdfDownloadImageURL= DLUtil.getPreviewURL(pdfIconFileEntry, pdfIconFileEntry.getFileVersion(), themeDisplay, "") >

<#list fileEntries as dlFileEntry>
     <#if dlFileEntry ?? >
         <#assign fileEntry =DLAppLocalService.getFileEntry(dlFileEntry.getFileEntryId()) />
          <#if fileEntry??  >
            <#assign downloadURL=DLUtil.getDownloadURL(fileEntry,fileEntry.getFileVersion(),themeDisplay,"") />
                <div class="download-list">
                    <div class="imageDiv">
                       <a href="<#if downloadURL??>${downloadURL}</#if>" >
                       <img src="<#if pdfDownloadImageURL ??>${pdfDownloadImageURL}</#if>" />
                       </a>
                    </div>
                    <div class="title">
                       <a href="<#if downloadURL??>${downloadURL}</#if>">
                          <p class="description">
                               <#if fileEntry.getDescription()??>
                                ${fileEntry.getDescription()} 
                               </#if>
                           </p>
                        </a>
                     </div>
                </div>
            </#if>
        </#if>    
        </#list>
<#recover>
</#attempt>